package com.agilex.healthcare.mobilehealthplatform.domain;

import com.agilex.healthcare.mobilehealthplatform.domain.sorting.PatientSortingAlgorithm;
import com.agilex.healthcare.utility.DOBDateMarshaller;
import com.agilex.healthcare.utility.NullChecker;
import com.agilex.healthcare.veteranappointment.serializer.JsonDOBDateSerializer;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import javax.xml.bind.annotation.*;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.net.URI;

@XmlRootElement(
        name = "patient",
        namespace = "http://healthcare.agilex.com/mobilehealthplatform"
)
@XmlAccessorType(XmlAccessType.NONE)
public class Patient extends DomainTransferObject implements Comparable<Patient> {
    private static final long serialVersionUID = -3040524557861665627L;
    private String displayName = null;
    @XmlElement
    private String firstName;
    @XmlElement
    private String lastName;
    @XmlElement
    private String middleName;
    @JsonSerialize(using = JsonDOBDateSerializer.class)
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "MMM dd, yyyy")
    @XmlElement
    @XmlJavaTypeAdapter(DOBDateMarshaller.class)
    private DOBDate dateOfBirth;
    @XmlElement
    private String gender;
    @XmlElement
    private PatientIdentifier patientIdentifier = new PatientIdentifier();
    @XmlElement
    private String ssn;
    @XmlElement
    private String middleInitial;
    @XmlElement
    private String age = null;
    @XmlElement
    private String wardLocation = null;
    @XmlElement
    private String roombed = null;
    @XmlElement
    private String enterpriseId;
    @XmlElement
    private boolean inpatient;
    @XmlElement
    private boolean textMessagingAllowed;
    @XmlElement
    private String textMessagingPhoneNumber;

    public Patient() {
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getSsn() {
        return this.ssn;
    }

    public void setSsn(String ssn) {
        this.ssn = ssn;
    }

    public String getMiddleName() {
        return this.middleName;
    }

    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    public DOBDate getDateOfBirth() {
        return this.dateOfBirth;
    }

    public void setDateOfBirth(DOBDate dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public String getGender() {
        return this.gender;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    @XmlTransient
    public URI getDemographicsUri() {
        AtomLink link = this.getLink().getLinkByTitle("patient-demographics");
        return AtomLink.extractUri(link);
    }

    public void setDemographicsUri(URI uri) {
        AtomLink link = new AtomLink();
        link.setHref(uri);
        link.setRel("related");
        link.setTitle("patient-demographics");
        this.getLink().setLinkByTitle(link);
    }

    public String getId() {
        return this.getPatientIdentifier().getUniqueId();
    }

    public void setId(String id) {
        this.getPatientIdentifier().setUniqueId(id);
    }

    public String getWardLocation() {
        return this.wardLocation;
    }

    public void setWardLocation(String wardLocation) {
        this.wardLocation = wardLocation;
    }

    public String getRoombed() {
        return this.roombed;
    }

    public void setRoombed(String roombed) {
        this.roombed = roombed;
    }

    @XmlTransient
    public URI getDocumentsUri() {
        AtomLink link = this.getLink().getLinkByTitle("patient-documents");
        return AtomLink.extractUri(link);
    }

    public void setDocumentsUri(URI uri) {
        AtomLink link = new AtomLink();
        link.setHref(uri);
        link.setRel("related");
        link.setTitle("patient-documents");
        this.getLink().setLinkByTitle(link);
    }

    public URI getPatientImageUri() {
        AtomLink link = this.getLink().getLinkByTitle("patient-image");
        return AtomLink.extractUri(link);
    }

    public void setPatientImageUri(URI uri) {
        AtomLink link = new AtomLink();
        link.setHref(uri);
        link.setRel("related");
        link.setTitle("patient-image");
        this.getLink().setLinkByTitle(link);
    }

    public URI getProblemsUri() {
        AtomLink link = this.getLink().getLinkByTitle("patient-problems");
        return AtomLink.extractUri(link);
    }

    public void setProblemsUri(URI uri) {
        AtomLink link = new AtomLink();
        link.setHref(uri);
        link.setRel("related");
        link.setTitle("patient-problems");
        this.getLink().setLinkByTitle(link);
    }

    public void setOutpatientProblemsUri(URI uri) {
        AtomLink link = new AtomLink();
        link.setHref(uri);
        link.setRel("related");
        link.setTitle("patient-problems-outpatient");
        this.getLink().setLinkByTitle(link);
    }

    public void setInpatientProblemsUri(URI uri) {
        AtomLink link = new AtomLink();
        link.setHref(uri);
        link.setRel("related");
        link.setTitle("patient-problems-inpatient");
        this.getLink().setLinkByTitle(link);
    }

    public void setMiddleInitial(String middleInitial) {
        this.middleInitial = middleInitial;
    }

    public String getMiddleInitial() {
        return this.middleInitial;
    }

    public URI getAllergiesUri() {
        AtomLink link = this.getLink().getLinkByTitle("patient-allergies");
        return AtomLink.extractUri(link);
    }

    public void setAllergiesUri(URI uri) {
        AtomLink link = new AtomLink();
        link.setHref(uri);
        link.setRel("related");
        link.setTitle("patient-allergies");
        this.getLink().setLinkByTitle(link);
    }

    public URI Surgeries() {
        AtomLink link = this.getLink().getLinkByTitle("patient-surgeries");
        return AtomLink.extractUri(link);
    }

    public void setSurgeriesUri(URI uri) {
        AtomLink link = new AtomLink();
        link.setHref(uri);
        link.setRel("related");
        link.setTitle("patient-surgeries");
        this.getLink().setLinkByTitle(link);
    }

    public URI getLabResultsUri() {
        AtomLink link = this.getLink().getLinkByTitle("patient-lab-results");
        return AtomLink.extractUri(link);
    }

    public URI getVitalsUri() {
        AtomLink link = this.getLink().getLinkByTitle("patient-vitals");
        return AtomLink.extractUri(link);
    }

    public URI getLongitudinalVitalsUri() {
        AtomLink link = this.getLink().getLinkByTitle("patient-vitals-longitudinal");
        return AtomLink.extractUri(link);
    }

    public URI getOperationalVitalsUri() {
        AtomLink link = this.getLink().getLinkByTitle("patient-vitals-operational");
        return AtomLink.extractUri(link);
    }

    public URI getPatientEnteredVitalsUri() {
        AtomLink link = this.getLink().getLinkByTitle("patient-entered-vitals");
        return AtomLink.extractUri(link);
    }

    public URI getProviderEnteredVitalsTableDataUri() {
        AtomLink link = this.getLink().getLinkByTitle("patient-vitals-tabledata-longitudinal");
        return AtomLink.extractUri(link);
    }

    public URI getProviderEnteredVitalsGraphDataUri() {
        AtomLink link = this.getLink().getLinkByTitle("patient-vitals-graphdata-longitudinal");
        return AtomLink.extractUri(link);
    }

    public void setLabResultsUri(URI uri) {
        AtomLink link = new AtomLink();
        link.setHref(uri);
        link.setRel("related");
        link.setTitle("patient-lab-results");
        this.getLink().setLinkByTitle(link);
    }

    public URI getLabTestHistoryUri() {
        return this.getLink().getUriByTitle("patient-lab-tests");
    }

    public void setLabTestHistoryUri(URI uri) {
        this.getLink().addRelatedLink("patient-lab-tests", uri);
    }

    public URI getLabTestHistoryByGroupUri() {
        return this.getLink().getUriByTitle("patient-lab-tests-by-group");
    }

    public void setLabTestHistoryByGroupUri(URI uri) {
        this.getLink().addRelatedLink("patient-lab-tests-by-group", uri);
    }

    public void setAge(String age) {
        this.age = age;
    }

    public String getAge() {
        return this.age;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @XmlElement
    public String getDisplayName() {
        if(NullChecker.isNullish(this.displayName)) {
            this.displayName = this.lastName + ", " + this.firstName;
        }

        return this.displayName;
    }

    public int compareTo(Patient patient) {
        PatientSortingAlgorithm algorithm = new PatientSortingAlgorithm();
        return algorithm.compare(this, patient);
    }

    public void setPatientIdentifier(PatientIdentifier patientIdentifier) {
        this.patientIdentifier = patientIdentifier;
    }

    public PatientIdentifier getPatientIdentifier() {
        if(this.patientIdentifier == null) {
            this.patientIdentifier = new PatientIdentifier();
        }

        return this.patientIdentifier;
    }

    public static String serializePatientIdentifier(Patient patient) {
        String s = null;
        if(patient != null) {
            s = patient.getPatientIdentifier().toString();
        }

        return s;
    }

    public void setEnterpriseId(String enterpriseId) {
        this.enterpriseId = enterpriseId;
    }

    public String getEnterpriseId() {
        return this.enterpriseId;
    }

    public boolean isInpatient() {
        return this.inpatient;
    }

    public void setInpatient(boolean inpatient) {
        this.inpatient = inpatient;
    }

    public URI getMicroLabResultsUri() {
        AtomLink link = this.getLink().getLinkByTitle("patient-lab-micro-results");
        return AtomLink.extractUri(link);
    }

    public void setMicroLabResultsUri(URI uri) {
        AtomLink link = new AtomLink();
        link.setHref(uri);
        link.setRel("related");
        link.setTitle("patient-lab-micro-results");
        this.getLink().setLinkByTitle(link);
    }

    public URI getMicroLabTestHistoryUri() {
        return this.getLink().getUriByTitle("patient-lab-micro-tests");
    }

    public void setMicroLabTestHistoryUri(URI uri) {
        this.getLink().addRelatedLink("patient-lab-micro-tests", uri);
    }

    public URI getMicroLabTestHistoryByGroupUri() {
        return this.getLink().getUriByTitle("patient-lab-micro-tests-by-group");
    }

    public void setMicroLabTestHistoryByGroupUri(URI uri) {
        this.getLink().addRelatedLink("patient-lab-micro-tests-by-group", uri);
    }

    public URI getMedicationsUri() {
        AtomLink link = this.getLink().getLinkByTitle("patient-medications");
        return AtomLink.extractUri(link);
    }

    public void setMedicationsUri(URI uri) {
        AtomLink link = new AtomLink();
        link.setHref(uri);
        link.setRel("related");
        link.setTitle("patient-medications");
        this.getLink().setLinkByTitle(link);
    }

    public URI getActiveMedicationsUri() {
        AtomLink link = this.getLink().getLinkByTitle("patient-medications-active");
        return AtomLink.extractUri(link);
    }

    public void setActiveMedicationsUri(URI uri) {
        AtomLink link = new AtomLink();
        link.setHref(uri);
        link.setRel("related");
        link.setTitle("patient-medications-active");
        this.getLink().setLinkByTitle(link);
    }

    public URI getMedicationRefillsUri() {
        AtomLink link = this.getLink().getLinkByTitle("patient-medication-refills");
        return AtomLink.extractUri(link);
    }

    public void setMedicationRefillsUri(URI uri) {
        AtomLink link = new AtomLink();
        link.setHref(uri);
        link.setRel("related");
        link.setTitle("patient-medication-refills");
        this.getLink().setLinkByTitle(link);
    }

    public URI getOutpatientMedicationsUri() {
        AtomLink link = this.getLink().getLinkByTitle("patient-medications-outpatient");
        return AtomLink.extractUri(link);
    }

    public void setOutpatientMedicationsUri(URI uri) {
        AtomLink link = new AtomLink();
        link.setHref(uri);
        link.setRel("related");
        link.setTitle("patient-medications-outpatient");
        this.getLink().setLinkByTitle(link);
    }

    public URI getCurrentOutpatientMedicationsUri() {
        AtomLink link = this.getLink().getLinkByTitle("patient-medications-outpatient-active");
        return AtomLink.extractUri(link);
    }

    public void setCurrentOutpatientMedicationsUri(URI uri) {
        AtomLink link = new AtomLink();
        link.setHref(uri);
        link.setRel("related");
        link.setTitle("patient-medications-outpatient-active");
        this.getLink().setLinkByTitle(link);
    }

    public URI getInpatientMedicationsUri() {
        AtomLink link = this.getLink().getLinkByTitle("patient-medications-inpatient");
        return AtomLink.extractUri(link);
    }

    public void setInpatientMedicationsUri(URI uri) {
        AtomLink link = new AtomLink();
        link.setHref(uri);
        link.setRel("related");
        link.setTitle("patient-medications-inpatient");
        this.getLink().setLinkByTitle(link);
    }

    public URI getCurrentInpatientMedicationsUri() {
        AtomLink link = this.getLink().getLinkByTitle("patient-medications-inpatient-active");
        return AtomLink.extractUri(link);
    }

    public void setCurrentInpatientMedicationsUri(URI uri) {
        AtomLink link = new AtomLink();
        link.setHref(uri);
        link.setRel("related");
        link.setTitle("patient-medications-inpatient-active");
        this.getLink().setLinkByTitle(link);
    }

    public URI getMentalHealthAppointmentUri() {
        AtomLink link = this.getLink().getLinkByTitle("patient-appointments-mental-health");
        return AtomLink.extractUri(link);
    }

    public URI getAssessmentResultsUri() {
        AtomLink link = this.getLink().getLinkByTitle("patient-assessment-results");
        return AtomLink.extractUri(link);
    }

    public void setAssessmentResultsUri(URI uri) {
        AtomLink link = new AtomLink();
        link.setHref(uri);
        link.setRel("related");
        link.setTitle("patient-assessment-results");
        this.getLink().setLinkByTitle(link);
    }

    public void setAssessmentDraftsUri(URI uri) {
        AtomLink link = new AtomLink();
        link.setHref(uri);
        link.setRel("related");
        link.setTitle("patient-assessment-draft");
        this.getLink().setLinkByTitle(link);
    }

    public URI getAssessmentGraphDataUri() {
        AtomLink link = this.getLink().getLinkByTitle("patient-assessment-graphdata");
        return AtomLink.extractUri(link);
    }

    public void setAssessmentGraphDataUri(URI uri) {
        AtomLink link = new AtomLink();
        link.setHref(uri);
        link.setRel("related");
        link.setTitle("patient-assessment-graphdata");
        this.getLink().setLinkByTitle(link);
    }

    public URI getMygoalsUri() {
        AtomLink link = this.getLink().getLinkByTitle("mygoals-inventory");
        return AtomLink.extractUri(link);
    }

    public void setMygoalsUri(URI uri) {
        AtomLink link = new AtomLink();
        link.setHref(uri);
        link.setRel("related");
        link.setTitle("mygoals-inventory");
        this.getLink().setLinkByTitle(link);
    }

    public boolean isTextMessagingAllowed() {
        return this.textMessagingAllowed;
    }

    public void setTextMessagingAllowed(boolean textMessagingAllowed) {
        this.textMessagingAllowed = textMessagingAllowed;
    }

    public String getTextMessagingPhoneNumber() {
        return this.textMessagingPhoneNumber;
    }

    public void setTextMessagingPhoneNumber(String textMessagingPhoneNumber) {
        this.textMessagingPhoneNumber = textMessagingPhoneNumber;
    }
}

